--
--	      
--
function getMail(silent)
	--
	local log_id = "_emails_server_"
	--
	if (silent == nil) then
		silent = false
	end
	--
	log(log_id, ">>>>>>>>>> Welcome to email server <<<<<<<<<<<<")
	--
	local emails_sent = false
	local e = Emails
	local day = tonumber(getVariable("time_day"))
	local hour = tonumber(getVariable("time_hour"))
	local minute = tonumber(getVariable("time_minute"))
	--
	log(log_id, "Server time:", "Day "..day..", "..hour..":"..minute)
	--
	local checkEmail = function(email, data)
		if (data.sent == false) then
			log(log_id, ">>", email, "processing")
			if (data.day ~= 0) then
				log(log_id, ">>>>", "pending")
				if (data.day <= day) then
					log(log_id, ">>>>>>", "it's the day")
					if (data.hour <= hour) then
						log(log_id, ">>>>>>>>", "it's the hour")
						if (data.minute <= minute) then
							log(log_id, ">>>>>>>>>>", "it's the minute", "sending away")
							
							sendMail(email, nil, nil, true)
							--Emails[email].send(true)
							
							log(log_id, ">>>>>>>>>>", email, "has been sent to", data.inbox, "status", data.status)
							
							emails_sent = true
						else
							log(log_id, ">>>>>>>>>>", "not the minute")
						end
					else
						log(log_id, ">>>>>>>>", "not the hour")
					end
				else
					log(log_id, ">>>>>>", "not the day")
				end
			else
				log(log_id, ">>>>", "not pending")
			end
		end
	end
	--
	table.foreach(e, checkEmail)
	--
	if ((emails_sent == true) and (silent == false)) then
		sendMessage(NEW_EMAIL, NEW_EMAIL)
	end
	--
	log(log_id, ">>>>>>>>>> Email server out <<<<<<<<<<<<")
	--
end

ipaAnswerSended = false

function sendIPAAnswer(name)
	local log_id = "_emails_server_"
	log(log_id, "Check IPA...",ipaAnswerSended)

	if(not ipaAnswerSended) then

		local findImp = function(index, merc)
			if(Mercs[index].hired and (string.sub(index,1,4)=="imp_")) then
				name = index
			end
		end

		if(not isValid(name)) then
			log(log_id, "Try find imp...")
			table.foreach(Mercs,findImp)
		end

		if(isValid(name)) then
			log(log_id, "Imp founded:",name)
			ipaAnswerSended = true
			local attitude = getPersonParameterStr(name, "ATTITUDE")
			if(isValid(attitude)) then
				attitude = string.lower(attitude)
			end
			local phobia = getPersonParameterStr(name, "PHOBIA")
			if(isValid(phobia)) then
				phobia = string.lower(phobia)
			end
			local skill1 = getPersonParameterStr(name, "SKILL1")
			if(isValid(skill1)) then
				skill1 = string.lower(skill1)
			end
			local skill2 = getPersonParameterStr(name, "SKILL2")
			if(isValid(skill2)) then
				skill2 = string.lower(skill2)
			end
			if(isValid(attitude) and (attitude~="none")) then
				sendEmail("ipa_attitude_"..attitude, INBOX, UNREAD)
			end
			if(isValid(phobia) and (phobia~="none")) then
				sendEmail("ipa_phobia_"..phobia, INBOX, UNREAD)
			end
			if(isValid(skill1) and (skill1~="none")) then
				sendEmail("ipa_skill_"..skill1, INBOX, UNREAD)
			end
			if(isValid(skill2) and (skill2~="none")) then
				sendEmail("ipa_skill_"..skill2, INBOX, UNREAD)
			end
			sendMessage(NEW_EMAIL, NEW_EMAIL)
		else
			log(log_id, "Imp NOT founded.")
		end
	end
end